% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaRIVER.R
\name{evaRIVER}
\alias{evaRIVER}
\title{Evaluation of RIVER}
\usage{
evaRIVER(dataInput, pseudoc = 50, theta_init = matrix(c(0.99, 0.01, 0.3,
  0.7), nrow = 2), costs = c(100, 10, 1, 0.1, 0.01, 0.001, 1e-04),
  verbose = FALSE)
}
\arguments{
\item{dataInput}{An object of ExpressionSet class which contains input data
required for all functions in RIVER including genomic features,
outlier status, and N2 pairs.}

\item{pseudoc}{Pseudo count.}

\item{theta_init}{Initial values of theta.}

\item{costs}{Candidate penalty parameter values for L2-regularized logistic
regression.}

\item{verbose}{Logical option for showing extra information on progress.}
}
\value{
A list which contains two AUC values from RIVER and GAM, computed
        specificities and sensitivities from two models, and P-value of
        comparing the two AUC values.
}
\description{
\code{evaRIVER} trains RIVER by holding out a list of individual and gene
        pairs having same rare variants for evaluation, computes test
        posterior probabilities of FR for 1st individual, and compares
        them with outlier status of 2nd individual from the list.
}
\section{Warning}{
 A vector of candidate penalty values make \code{glmnet}
        faster than to input a single penalty value
}

\examples{
dataInput <- getData(filename=system.file("extdata", "simulation_RIVER.gz",
        package = "RIVER"), ZscoreThrd=1.5)
evaROC <- evaRIVER(dataInput, verbose=TRUE)

}
\seealso{
\code{\link[glmnet]{cv.glmnet}}, \code{\link{predict}},
        \code{\link{integratedEM}}, \code{\link{testPosteriors}},
        \code{\link{getData}}, \code{\link[Biobase]{exprs}}
}
\author{
Yungil Kim, \email{ipw012@gmail.com}
}
