% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StyleDefaults.R
\name{setNodeCustomRadialGradient}
\alias{setNodeCustomRadialGradient}
\title{Set Node Custom Radial Gradient}
\usage{
setNodeCustomRadialGradient(
  colors = c("#DDDDDD", "#888888"),
  anchors = c(0, 1),
  xCenter = 0.5,
  yCenter = 0.5,
  slot = 1,
  style.name = NULL,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{colors}{(optional) List of colors to define gradient}

\item{anchors}{(optional) Position of colors from 0.0 to 1.0.}

\item{xCenter}{(optional) X position for center of radial effect from 0.0 
to 1.0. Default is 0.5.}

\item{yCenter}{(optional) Y position for center of radial effect from 0.0 
to 1.0. Default is 0.5.}

\item{slot}{(optional) Which custom graphics slot to modify. Slots 1-9 are 
available for independent charts, gradients and images. Default is 1.}

\item{style.name}{(optional) Name of style; default is "default" style}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
None
}
\description{
Makes a gradient fill per node by setting a default custom 
graphic style.
}
\examples{
\donttest{
setNodeCustomRadialGradient()
}
}
