% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Networks.R
\name{getEdgeInfo}
\alias{getEdgeInfo}
\title{Get Edge Information}
\usage{
getEdgeInfo(edges, network = NULL, base.url = .defaultBaseUrl)
}
\arguments{
\item{edges}{List of SUIDs or names of edges, i.e., values in the "name" 
column. Can also input a single edge.}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
\code{named list of lists}
}
\description{
Returns source, target and edge table row values.
}
\details{
This function is kinda slow. It takes approximately 70ms per edge 
to return a result, e.g., 850 edges will take a one minute.
}
\examples{
\donttest{
getEdgeInfo()
}
}
\author{
Alexander Pico
}
