% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filters.R
\name{createCompositeFilter}
\alias{createCompositeFilter}
\title{Create Composite Filter}
\usage{
createCompositeFilter(
  filter.name,
  filter.list,
  type = "ALL",
  hide = FALSE,
  network = NULL,
  base.url = .defaultBaseUrl,
  apply = TRUE
)
}
\arguments{
\item{filter.name}{Name for filter.}

\item{filter.list}{List of filters to combine.}

\item{type}{(optional) Type of composition, requiring ALL (default) or ANY
filters to pass for final node and edge selection.}

\item{hide}{Whether to hide filtered out nodes and edges. Default is FALSE.
Ignored if all nodes or edges are filtered out. This is an alternative to 
filtering for node and edge selection.}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}

\item{apply}{(bool) True to execute filter immediately (default); False to
define filter but not execute it (available in Cytoscape 3.9+).}
}
\value{
List of selected nodes and edges.
}
\description{
Combines filters to control node and edge selection based on
previously created filters.
}
\examples{
\donttest{
createCompositeFilter("comp1", c("filter1", "filter2"))
createCompositeFilter("comp2", c("filter1", "filter2"), "ANY")
createCompositeFilter("comp3", c("comp1", "filter3"), apply=FALSE)
}
}
