% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils-general.R
\name{.mergeAttributesAspect}
\alias{.mergeAttributesAspect}
\title{Merge two *AttributeAspects}
\usage{
.mergeAttributesAspect(
  firstAspect,
  secondAspect,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  required = c("propertyOf", "name"),
  optional = "subnetworkId",
  .log = c()
)
}
\arguments{
\item{firstAspect}{*AttributeAspect object; first aspect.}

\item{secondAspect}{*AttributeAspect object; second aspect.}

\item{replace}{logical (default: TRUE); should duplicate keys be replaced with values of the secondAspect}

\item{stopOnDuplicates}{logical (default: FALSE); whether to stop, if duplicate keys are found}

\item{required}{character (optional); names of required column names}

\item{optional}{character (optional); names of optional column names}

\item{.log}{character (optional); origin of the data used for error logging}
}
\value{
*AttributeAspect object
}
\description{
Some aspects like \emph{NodeAttributesAspect} or \emph{EdgeAttributesAspect} use a key-value scheme.
This function helps in merging while avoiding repetition.
}
\note{
Internal function only for convenience
}
\examples{
NULL
}
\seealso{
\code{\link{.mergeIdAspect}}, \code{\link{.createAttributeAspect}}
}
\keyword{internal}
