% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-Cytoscape-VisualProperties.R
\name{CyVisualProperties}
\alias{CyVisualProperties}
\alias{createCyVisualProperties}
\title{Cytoscape visual properties (aspect)}
\usage{
createCyVisualProperties(
  network = NULL,
  nodes = NULL,
  edges = NULL,
  defaultNodes = NULL,
  defaultEdges = NULL
)
}
\arguments{
\item{network}{\code{\link{CyVisualProperty}} object (optional); the visual properties of networks}

\item{nodes}{\code{\link{CyVisualProperty}} object (optional); the visual properties of nodes}

\item{edges}{\code{\link{CyVisualProperty}} object (optional); the visual properties of edges}

\item{defaultNodes}{\code{\link{CyVisualProperty}} object (optional); the default visual properties of nodes}

\item{defaultEdges}{\code{\link{CyVisualProperty}} object (optional); the default visual properties of edges}
}
\value{
\emph{CyVisualPropertiesAspect} object
}
\description{
This function is used to create Cytoscape visual properties aspects, that consists of \code{\link{CyVisualProperty}} objects for
networks, nodes, edges, and default nodes and edges.
}
\details{
Cytoscape contributes aspects that organize subnetworks, attribute tables, and visual attributes for use by its own layout and
analysis tools. Furthermore are the aspects used in web-based visualizations like within the NDEx platform.

The visual properties aspect is the only aspect (\code{\link{CyVisualProperties}}) with a complex structure. It is composed of several sub-property classes and
consists of \code{\link{CyVisualProperty}} objects, that belong to, or more precisely describe one of the following network elements:
\emph{network}, \emph{nodes}, \emph{edges}, \emph{defaultNodes} or \emph{defaultEdges}.

A single visual property (i.e. \code{\link{CyVisualProperty}} object) organizes the information as \emph{properties}, \emph{dependencies} and \emph{mappings},
as well as the single values \emph{appliesTo} and \emph{view}, that define the subnetwork or view to which the IDs apply.

Properties are \code{\link{CyVisualPropertyProperties}} objects, that hold information like
\code{"NODE_FILL_COLOR" : "#26CCC9"} or \code{"NODE_LABEL_TRANSPARENCY" : "255"} in a key-value like manner.

Dependencies are \code{\link{CyVisualPropertyDependencies}} objects, that hold information
about dependencies between visual properties.
Currently there are only three dependencies supported:
\itemize{
\item Lock Node with and height: \code{nodeSizeLocked = "false"}
\item Fit Custom Graphics to node: \code{nodeCustomGraphicsSizeSync = "true"}
\item Edge color to arrows: \code{arrowColorMatchesEdge = "false"}
}

Mappings are \code{\link{CyVisualPropertyMappings}} objects, that hold information as a triplet consisting of name, type and definition, like
\code{"NODE_FILL_COLOR" : "DISCRETE" : "COL=molecule_type,T=string,K=0=miRNA,V=0=#FCEC00"},
\verb{"NODE_FILL_COLOR" : "CONTINUOUS" : "COL=gal1RGexp,T=double...} or
\code{"NODE_LABEL" : "PASSTHROUGH" : "COL=COMMON,T=string"}.

For further information about Cytoscape visual properties see the \code{Styles} topic of the official Cytoscape documentation:
\href{http://manual.cytoscape.org/en/stable/Styles.html}{http://manual.cytoscape.org/en/stable/Styles.html}

\subsection{Structure of Cytoscape Visual Properties}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{CyVisualProperties
|---network = CyVisualProperty
|---nodes = CyVisualProperty
|---edges = CyVisualProperty
|---defaultNodes = CyVisualProperty
|---defaultEdges = CyVisualProperty

CyVisualProperty
|---properties = CyVisualPropertyProperties
|   |--name
|   |--value 
|---dependencies = CyVisualPropertyDependencies
|   |--name
|   |--value 
|---mappings = CyVisualPropertyMappings
|   |--name
|   |--type
|   |--definition 
|---appliesTo = <reference to subnetwork id>
|---view = <reference to subnetwork id>
}\if{html}{\out{</div>}}
}
}
\examples{
## Prepare used properties
## Visual property: Properties
vpPropertyP1 = createCyVisualPropertyProperties(c(NODE_BORDER_STROKE="SOLID"))

## Visual property: Dependencies
vpPropertyD1 = createCyVisualPropertyDependencies(c(nodeSizeLocked="false"))

## Visual property: Mappings
vpPropertyM1 = createCyVisualPropertyMappings(c(NODE_FILL_COLOR="CONTINUOUS"), 
                                              "COL=directed,T=boolean,K=0=true,V=0=ARROW")

## Create visual property object 
vpProperty1 = createCyVisualProperty(properties=vpPropertyP1, 
                                     dependencies=vpPropertyD1, 
                                     mappings=vpPropertyM1)

## Create a visual properties aspect
## (using the same visual property object for simplicity)
createCyVisualProperties(network=vpProperty1, 
                         nodes=vpProperty1, 
                         edges=vpProperty1, 
                         defaultNodes=vpProperty1, 
                         defaultEdges=vpProperty1)
}
\seealso{
\code{\link{updateCyVisualProperties}}, \code{\link{updateCyVisualProperty}}, \code{\link{getCyVisualProperty}}
}
