% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-Cytoscape-Groups.R
\name{updateCyGroups}
\alias{updateCyGroups}
\alias{updateCyGroups.CyGroupsAspect}
\alias{updateCyGroups.RCX}
\title{Update Cytoscape Groups}
\usage{
updateCyGroups(x, cyGroups, stopOnDuplicates = FALSE, keepOldIds = TRUE, ...)

\method{updateCyGroups}{CyGroupsAspect}(x, cyGroups, stopOnDuplicates = FALSE, keepOldIds = TRUE, ...)

\method{updateCyGroups}{RCX}(
  x,
  cyGroups,
  stopOnDuplicates = FALSE,
  keepOldIds = TRUE,
  checkReferences = TRUE,
  ...
)
}
\arguments{
\item{x}{\link[=RCX-object]{RCX} or \code{\link{CyGroups}} object; (to which the new Cytoscape groups will be added)}

\item{cyGroups}{\code{\link{CyGroups}} object; (the new aspect, that will be added)}

\item{stopOnDuplicates}{logical; whether to stop, if duplicates in \code{id} column are found, or re-assign ids instead.}

\item{keepOldIds}{logical; if ids are re-assigned, the original ids are kept in the column \emph{oldId}}

\item{...}{additional parameters}

\item{checkReferences}{logical; whether to check if references to other aspects are present in the \link[=RCX-object]{RCX} object}
}
\value{
\code{\link{CyGroups}} or \link[=RCX-object]{RCX} object with added Cytoscape groups
}
\description{
This functions add Cytoscape groups in the form of a \code{\link{CyGroups}} object to an \link[=RCX-object]{RCX} or an other \code{\link{CyGroups}} object.
}
\details{
Cytoscape groups allow to group a set of nodes and corresponding internal and external edges together, and represent a group as
a single node in the visualization.
\code{\link{CyGroups}} objects can be added to an \link[=RCX-object]{RCX} or an other \code{\link{CyGroups}} object.
The \emph{nodes}, \emph{internalEdges} and \emph{externalEdges} parameters reference the node or edge IDs that belong to a group.
When adding an \code{\link{CyGroups}} object to an \link[=RCX-object]{RCX} object, those IDs must be present in the \code{\link{Nodes}}
or \code{\link{Edges}} aspect respectively, otherwise an error is raised.

When two groups should be added to each other some conflicts may rise, since the aspects might use the same IDs.
If the aspects do not share any IDs, the two aspects are simply combined. Otherwise, the IDs of the new groups are re-assinged
continuing with the next available ID (i.e. \code{\link{maxId}}(cyGroupsAspect) + 1 and \code{\link{maxId}}(rcx$cyGroups) + 1, respectively).

To keep track of the changes, it is possible to keep the old IDs of the newly added nodes in the automatically added column \emph{oldId}.
This can be omitted by setting \emph{keepOldIds} to \code{FALSE}.
Otherwise, if a re-assignment of the IDs is not desired, this can be prevented by setting \emph{stopOnDuplicates} to \code{TRUE}.
This forces the function to stop and raise an error, if duplicated IDs are present.
}
\examples{
## For CyGroupsAspects: 
## prepare some aspects:
cyGroups1 = createCyGroups(
  name = c("Group One", "Group Two"),
  nodes = list(c(1,2,3), 0),
  internalEdges = list(c(0,1),NA),
  externalEdges = list(NA,c(2,3)),
  collapsed = c(TRUE,NA)                     
)

cyGroups2 = createCyGroups(
  name = "Group Three",
  nodes = list(c(4,5)),
  externalEdges = list(c(4,5))                     
)

## group ids will be kept
cyGroups3 = updateCyGroups(cyGroups1, cyGroups2)

## old group ids will be omitted
cyGroups3 = updateCyGroups(cyGroups1, cyGroups2,
                           keepOldIds=FALSE)

## Raise an error if duplicate keys are present
try(updateCyGroups(cyGroups1, cyGroups2,
                   stopOnDuplicates=TRUE))
## =>ERROR: 
## Elements of "id" (in updateCyGroups) must not contain duplicates!

## For RCX
## prepare RCX object:
nodes = createNodes(name = c("a","b","c","d","e","f"))
edges = createEdges(source=c(1,2,0,0,0,2), 
                    target=c(2,3,1,2,5,4))
rcx = createRCX(nodes, edges)

## add the group
rcx = updateCyGroups(rcx, cyGroups1)

## add an additional group
rcx = updateCyGroups(rcx, cyGroups2)

## create a group with a not existing node...
cyGroups3 = createCyGroups(
  name = "Group Three",
  nodes = list(9)                    
)

## ...and try to add them
try(updateCyGroups(rcx, cyGroups3))
## =>ERROR: 
## Provided IDs of "additionalGroups$nodes" (in updateCyGroups) 
## don't exist in "rcx$nodes$id"

## create a group with a not existing edge...
cyGroups4 = createCyGroups(
  name = "Group Four",
  nodes = list(c(1,2)),
  internalEdges = list(c(9))
)

## ...and try to add them
try(updateCyGroups(rcx, cyGroups4))
## =>ERROR: 
## Provided IDs of "additionalGroups$internalEdges" (in updateCyGroups) 
## don't exist in "rcx$edges$id"
}
\seealso{
\code{\link{CyGroups}};
}
