% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-Cytoscape-VisualProperties.R
\name{CyVisualPropertyDependencies}
\alias{CyVisualPropertyDependencies}
\alias{createCyVisualPropertyDependencies}
\title{Create a object for dependency of Cytoscape Visual Properties (object used in CyVisualProperty)}
\usage{
createCyVisualPropertyDependencies(value, name = NULL)
}
\arguments{
\item{value}{character or named character; value of the dependencies}

\item{name}{character (optional); name of the dependencies}
}
\value{
CyVisualPropertyDependencies object
}
\description{
This function is used to create aspects for mappings in \link[=CyVisualProperties]{Cytoscape visual properties}.
Networks, nodes, edges, and default nodes and edges mappings are realized as \code{\link{CyVisualProperty}} objects, that each consist of
properties (\code{\link{CyVisualPropertyProperties}} objects), dependencies (\strong{this here}) and mappings (\code{\link{CyVisualPropertyMappings}} objects).
}
\details{
Cytoscape contributes aspects that organize subnetworks, attribute tables, and visual attributes for use by its own layout and
analysis tools. Furthermore are the aspects used in web-based visualizations like within the NDEx platform.

The visual properties aspect is the only aspect (\code{\link{CyVisualProperties}}) with a complex structure. It is composed of several sub-property classes and
consists of \code{\link{CyVisualProperty}} objects, that belong to, or more precisely describe one of the following network elements:
\emph{network}, \emph{nodes}, \emph{edges}, \emph{defaultNodes} or \emph{defaultEdges}.

A single visual property (i.e. \code{\link{CyVisualProperty}} object) organizes the information as \emph{properties}, \emph{dependencies} and \emph{mappings},
as well as the single values \emph{appliesTo} and \emph{view}, that define the subnetwork or view to which the IDs apply.

Properties are \code{\link{CyVisualPropertyProperties}} objects, that hold information like
\code{"NODE_FILL_COLOR" : "#26CCC9"} or \code{"NODE_LABEL_TRANSPARENCY" : "255"} in a key-value like manner.

Dependencies are \code{\link{CyVisualPropertyDependencies}} objects, that hold information
about dependencies between visual properties.
Currently there are only three dependencies supported:
\itemize{
\item Lock Node with and height: \code{nodeSizeLocked = "false"}
\item Fit Custom Graphics to node: \code{nodeCustomGraphicsSizeSync = "true"}
\item Edge color to arrows: \code{arrowColorMatchesEdge = "false"}
}

Mappings are \code{\link{CyVisualPropertyMappings}} objects, that hold information as a triplet consisting of name, type and definition, like
\code{"NODE_FILL_COLOR" : "DISCRETE" : "COL=molecule_type,T=string,K=0=miRNA,V=0=#FCEC00"},
\verb{"NODE_FILL_COLOR" : "CONTINUOUS" : "COL=gal1RGexp,T=double...} or
\code{"NODE_LABEL" : "PASSTHROUGH" : "COL=COMMON,T=string"}.

For further information about Cytoscape visual properties see the \code{Styles} topic of the official Cytoscape documentation:
\href{http://manual.cytoscape.org/en/stable/Styles.html}{http://manual.cytoscape.org/en/stable/Styles.html}
}
\note{
If \emph{name} is not provided, the \emph{names(value)} is used instead to infer the names.
}
\examples{
## Using a named vector
vpDependencyNamedValue = c(nodeSizeLocked="false", 
                           arrowColorMatchesEdge="true")
createCyVisualPropertyDependencies(vpDependencyNamedValue)

## Using two separate vectors
vpDependencyName = c("nodeSizeLocked", 
                     "arrowColorMatchesEdge")
vpDependencyValue = c("false", 
                      "true")
createCyVisualPropertyDependencies(vpDependencyValue, 
                                   vpDependencyName)

# Result for either:
#                    name value
# 1        nodeSizeLocked false
# 2 arrowColorMatchesEdge  true
}
\seealso{
\code{\link{updateCyVisualProperty}}, \code{\link{updateCyVisualProperties}}
}
