% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-Cytoscape-SubNetworks.R
\name{CySubNetworks}
\alias{CySubNetworks}
\alias{createCySubNetworks}
\title{Cytoscape subnetworks}
\usage{
createCySubNetworks(id, nodes = NULL, edges = NULL)
}
\arguments{
\item{id}{integer; subnetwork IDs}

\item{nodes}{integer; reference to \link[=Nodes]{node id} OR character "all" to refer to all nodes}

\item{edges}{integer; reference to \link[=Edges]{edge id} OR character "all" to refer to all edges}
}
\value{
\emph{CySubNetworksAspect} object
}
\description{
This function is used to create Cytoscape subnetwork aspects.
}
\details{
Cytoscape contributes aspects that organize subnetworks, attribute tables, and visual attributes for use by its own layout and
analysis tools. Furthermore are the aspects used in web-based visualizations like within the NDEx platform.

A group is defined by its unique \emph{id}, which must be an (positive) integer, which serves as reference to other aspects.
If no IDs are provided, they are created automatically.

Nodes and edges are referred by the IDs of the corresponding aspect. Unlike other aspects referring those IDs, the Cytoscape
subnetwork aspect allows to refer to all nodes and edges using the keyword \code{all}.

The relationship between (sub-)networks and views, and also the type (subnetwork or view) is defined in \code{\link{CyNetworkRelations}}.
}
\examples{
## a minimal example
cySubNetworks = createCySubNetworks(
  nodes = "all",
  edges = "all"
)

## defining several subnetworks at once
cySubNetworks = createCySubNetworks(
  nodes = list("all",
               c(1,2,3)),
  edges = list("all",
               c(0,2))
)

## with all parameters
cySubNetworks = createCySubNetworks(
  id = c(0,1),
  nodes = list("all",
               c(1,2,3)),
  edges = list("all",
               c(0,2))                    
)

}
\seealso{
\code{\link{updateCySubNetworks}};
}
