% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_analysis.R
\name{discoverFeatureSpecificMotifs}
\alias{discoverFeatureSpecificMotifs}
\title{discoverFeatureSpecificMotifs}
\usage{
discoverFeatureSpecificMotifs(queryRegions, txdbFeatures, ...)
}
\arguments{
\item{queryRegions}{GRanges object containing coordinates of input query
regions imported by the \code{\link{importBed}} function}

\item{txdbFeatures}{A list of GRanges objects where each GRanges object
corresponds to the genomic coordinates of gene features such as promoters,
introns, exons, 5'/3' UTRs and whole transcripts.
This list of GRanges objects are obtained by the function
\code{\link{getTxdbFeaturesFromGRanges}} or \code{\link{getTxdbFeatures}}.}

\item{...}{Other arguments passed to \code{\link{runMotifRG}} function.
Important arguments are 'genomeVersion' and motifN. If motifN is bigger
than 1, then multiple motifs will be found but only the top motif will be
plotted.}
}
\value{
A data.frame object
}
\description{
This function groups query regions based on their overlap with different
transcript features and generates a table of top enriched motif and matching
patterns for each given transcript feature type along with some other motif 
discovery related statistics.
}
\examples{
\dontrun{
data(gff)
data(queryRegions)
txdbFeatures <- getTxdbFeaturesFromGRanges(gffData = gff)
discoverFeatureSpecificMotifs(queryRegions = queryRegions, 
genomeVersion = 'hg19', txdbFeatures = txdbFeatures, 
motifN = 1, nCores = 1)}

}
