% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{checkJavaMemory}
\alias{checkJavaMemory}
\title{Java Memory Settings}
\usage{
checkJavaMemory(units = "m")
}
\arguments{
\item{units}{Units to return the size in: "k", "m" or "g"}
}
\value{
The maximum amount of memory that the JVM will attempt to use,
  measured in \code{units}.
}
\description{
Information about the Java heap space usage.
}
\examples{
\dontrun{
## assign 4 gigabytes of heap space to the Java environment.
options( java.parameters = "-Xmx4g" )
library( "RBioFormats" )
}

checkJavaMemory()
}
\author{
Andrzej Oleś <\email{andrzej.oles@gmail.com}>, 2014-2023
}
