% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtle_name.R
\docType{methods}
\name{QTLe-name}
\alias{QTLe-name}
\alias{mainExpName}
\alias{mainExpName,QTLExperiment-method}
\alias{mainExpName<-}
\alias{mainExpName<-,QTLExperiment,character_OR_NULL-method}
\title{Return the name of a \linkS4class{QTLExperiment} object.}
\arguments{
\item{object}{A \linkS4class{QTLExperiment} object.}

\item{value}{Any character-like object or \code{NULL} to
remove existing labels.}
}
\value{
For \code{mainExpName(object)}, returns the name associated to \code{object}.

For \code{mainExpName(object) <- value}, the name of the object \code{object} is updated.
}
\description{
Returns the name of an object of class \linkS4class{QTLExperiment}.
}
\section{Available methods}{

In the following code snippets, \code{object} is a
\linkS4class{QTLExperiment} objects.

\describe{
\item{\code{mainExpName(object)}:}{Return the name assigned to \code{object}.}
\item{\code{mainExpName(object) <- value:}}{Change the name assigned to \code{object} 
to \code{value}.}
\item{\code{mainExpName(object) <- NULL:}}{Remove the name associated to \code{object}.}
}
}

\examples{
qtle <- mockQTLE()
mainExpName(qtle)
mainExpName(qtle) <- "test_name"
mainExpName(qtle)

}
\seealso{
\linkS4class{QTLExperiment}, for the underlying class definition.
}
\author{
Christina B. Azodi
}
