% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\name{checkProteotypicFragments}
\alias{checkProteotypicFragments}
\alias{checkProteotypicFragments,ProteoDiscography-method}
\title{Determine proteotypic fragments within the translated CDS}
\usage{
checkProteotypicFragments(
  x,
  enzymUsed = "trypsin",
  missedCleavages = 0,
  additionalPeptides = NULL,
  checkWithinMutantSeqs = FALSE
)

\S4method{checkProteotypicFragments}{ProteoDiscography}(
  x,
  enzymUsed = "Trypsin",
  missedCleavages = 0,
  additionalPeptides = NULL,
  checkWithinMutantSeqs = FALSE
)
}
\arguments{
\item{x}{({ProteoDiscography}): ProteoDiscography object which stores the annotation and genomic sequences.}

\item{enzymUsed}{(character): Preferred proteasome used in cleaving the peptide sequences, e.g. trypsin.}

\item{missedCleavages}{(integer): Number of subsequent missed cleavages.}

\item{additionalPeptides}{(AAStringSet): Additional peptide sequences against which to check proteotypic fragments, besides the input TxDb.
If left empty, only the (translated) input TxDb will be checked.}

\item{checkWithinMutantSeqs}{(logical): Should proteotypic fragments also not be present within another mutant peptide-sequence?}
}
\value{
ProteoDiscography with additional information added to the transcript sequence information.

{ProteoDiscography} with an additional column specifying the number of proteotypic fragments per record.
}
\description{
Proteotypic fragments are checked against the input TxDb (and additional peptide sequences) to infer whether peptide sequences
contain one or multiple proteotypic fragment(s) after cleavage by a selected protease.
}
\examples{

# Import example ProteoDiscography (hg19)
data('ProteoDiscographyExample.hg19', package = 'ProteoDisco')
ProteoDiscographyExample.hg19 <- setTxDb(ProteoDiscographyExample.hg19, TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene)
ProteoDiscographyExample.hg19 <- setGenomicSequences(ProteoDiscographyExample.hg19, BSgenome.Hsapiens.UCSC.hg19::BSgenome.Hsapiens.UCSC.hg19)

# Results will now contain additional information about proteotypic fragments.
# With a large TxDb, this can take a while.
# ProteoDiscography.hg19 <- ProteoDisco::checkProteotypicFragments(ProteoDiscographyExample.hg19)

}
\author{
Job van Riet \email{j.vanriet@erasmusmc.nl}

Wesley van de Geer \email{w.vandegeer@erasmusmc.nl}
}
\concept{methods}
\keyword{methods}
