% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_curve.R
\name{fit_curve}
\alias{fit_curve}
\title{Output the fit curve for a given mixture of Gaussians}
\usage{
fit_curve(coef, indices)
}
\arguments{
\item{coef}{numeric vector of coefficients for a Gaussian mixture model fit 
by \code{\link{fit_gaussians}}. This function assumes that the heights of the
Gaussians are specified by coefficients beginning with "A" 
("A1", "A2", "A3", etc.), centres are specified by coefficients beginning
with "mu", and standard deviations are specified by coefficients beginning
with "sigma".}

\item{indices}{the indices, or x-values, to predict a fitted curve for 
(for example, the fractions in a given chromatogram)}
}
\value{
the fitted curve
}
\description{
For a Gaussian mixture model fit to a curve by \code{\link{fit_gaussians}},
output the fit curve using the coefficients rather than the \code{nls} 
object. This allows individual Gaussians to be removed from the fit model:
for example, if their height is below a certain threshold, or their 
centres are outside the bounds of the chromatogram.
}
\examples{
data(scott)
chrom <- clean_profile(scott[1, ])
fit <- fit_gaussians(chrom, n_gaussians = 1)
curve <- fit_curve(fit$coefs, seq_along(chrom))

}
