% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatTestUnpaired.R
\name{ttest_unpaired}
\alias{ttest_unpaired}
\title{Perform unpaired t-tests on two datasets}
\usage{
ttest_unpaired(tData, trefData)
}
\arguments{
\item{tData}{A matrix or data frame with the quantitative features (via rows)
of the first group}

\item{trefData}{A matrix or data frame with the quantitative features
(via rows) of the second group}
}
\value{
A list containing the p-values and q-values for each row
}
\description{
Perform unpaired t-tests on two datasets
}
\details{
This function performs unpaired t-tests between corresponding rows of two
datasets.
It calculates the p-values and q-values for each row, indicating the
significance of the difference between the two datasets. We require
providing the same number of samples (columns) per group.
}
\examples{
tData <- matrix(rnorm(1000), nrow = 100)
trefData <- matrix(rnorm(1000), nrow = 100)
result <- ttest_unpaired(tData, trefData)
print(result$ptvalues)
print(result$qtvalues)

}
