% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/podcallPlots.R
\name{podcallScatterplot}
\alias{podcallScatterplot}
\title{podcallScatterplot}
\usage{
podcallScatterplot(channelData, thr, channel, plotId = NULL)
}
\arguments{
\item{channelData}{Amplitude values from one channel of a well.}

\item{thr}{The threshold set for \code{channel} of a well.}

\item{channel}{The channel the amplitude values belong to. Used to control
plot color.}

\item{plotId}{A character string with title for the plot.}
}
\value{
A scatterplot of all droplets from a channel from a well with a line
    indicating the set threshold.
}
\description{
Function that make a scatterplot of amplitude values from one
    channel of a well with threshold indicated by a horizontal line.
}
\examples{

# Get path to data
path <- system.file("extdata", "Amplitudes/", package="PoDCall")

# Read in data
data <- importAmplitudeData(path, skipLines=0)
data("thrTable")

# Get name of first list element and use as well ID
well_id <- names(data)[1]

# Set channel to plot
channel <- 1

# Get threshold for well_id and channel 1 (see ?thrTable)
thr <- thrTable[well_id, "thr_target"]

scatterplot <- podcallScatterplot(channelData=data[[well_id]][[channel]],
                                thr,
                                channel)

}
