% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFastaSeqs.R
\name{getFastaFromFolder}
\alias{getFastaFromFolder}
\title{Get fasta sequences}
\usage{
getFastaFromFolder(seqIDs = NULL, path = NULL, dirFormat = NULL,
    fileExt = NULL, idFormat = NULL)
}
\arguments{
\item{seqIDs}{list of sequences IDs.}

\item{path}{path to fasta folder.}

\item{dirFormat}{directory format (either 1 for "path/speciesID.fa*" or 2 for
"path/speciesID/speciesID.fa*")}

\item{fileExt}{fasta file extension ("fa", "fasta", "fas" or "txt")}

\item{idFormat}{fasta header format (1 for ">speciesID:seqID", 2 for
">speciesID@seqID", 3 for ">speciesID|seqID" or 4 for "seqID")}
}
\value{
A dataframe with one column contains sequences in fasta format.
}
\description{
Get fasta sequences for the input phylogenetic profiles.
}
\examples{
seqIDs <- "RAT@10116@1|D3ZUE4"
path <- system.file(
    "extdata", "fastaFiles", package = "PhyloProfile", mustWork = TRUE
)
dirFormat <- 1
fileExt <- "fa"
idFormat <- 3
getFastaFromFolder(seqIDs, path, dirFormat, fileExt, idFormat)
}
\seealso{
\code{\link{mainLongRaw}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
