% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateGeneAge.R
\name{estimateGeneAge}
\alias{estimateGeneAge}
\title{Calculate the phylogenetic gene age from the phylogenetic profiles}
\usage{
estimateGeneAge(processedProfileData, taxaCount, rankName, refTaxon,
    var1CO, var2CO, percentCO, taxDB = NULL)
}
\arguments{
\item{processedProfileData}{dataframe contains the full processed
phylogenetic profiles (see ?fullProcessedProfile or ?parseInfoProfile)}

\item{taxaCount}{dataframe counting present taxa in each supertaxon}

\item{rankName}{working taxonomy rank (e.g. "species", "genus", "family")}

\item{refTaxon}{reference taxon name (e.g. "Homo sapiens", "Homo" or
"Hominidae")}

\item{var1CO}{cutoff for var1. Default: c(0, 1)}

\item{var2CO}{cutoff for var2. Default: c(0, 1)}

\item{percentCO}{cutoff for percentage of species present in each
supertaxon. Default: c(0, 1)}

\item{taxDB}{Path to the taxonomy DB files}
}
\value{
A dataframe contains estimated gene ages for the seed proteins.
}
\description{
Calculate the phylogenetic gene age from the phylogenetic profiles
}
\examples{
library(dplyr)
data("fullProcessedProfile", package="PhyloProfile")
rankName <- "class"
refTaxon <- "Mammalia"
processedProfileData <- fullProcessedProfile
taxonIDs <- levels(as.factor(processedProfileData$ncbiID))
sortedInputTaxa <- sortInputTaxa(
    taxonIDs, rankName, refTaxon, NULL, NULL
)
taxaCount <- sortedInputTaxa \%>\% dplyr::count(supertaxon)
var1Cutoff <- c(0, 1)
var2Cutoff <- c(0, 1)
percentCutoff <- c(0, 1)
estimateGeneAge(
    processedProfileData,
    taxaCount,
    rankName,
    refTaxon,
    var1Cutoff, var2Cutoff, percentCutoff
)
}
\seealso{
\code{\link{parseInfoProfile}} for creating a full processed
profile dataframe; \code{\link{getNameList}} and
\code{\link{getTaxonomyMatrix}} for getting taxonomy info,
\code{\link{fullProcessedProfile}} for a demo input dataframe
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
