% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeDistribution.R
\name{createVarDistPlot}
\alias{createVarDistPlot}
\title{Create distribution plot}
\usage{
createVarDistPlot(data, varName = "var", varType = "var1",
    percent = c(0, 1), textSize = 12)
}
\arguments{
\item{data}{dataframe contains data for plotting (see
?createVariableDistributionData, ?createVariableDistributionDataSubset or
?createPercentageDistributionData)}

\item{varName}{name of the variable that need to be analyzed (either name of
variable 1 or variable 2 or "percentage of present taxa"). Default = "var".}

\item{varType}{type of variable (either "var1", "var2" or "presSpec").
Default = "var1".}

\item{percent}{range of percentage cutoff (between 0 and 1). Default = c(0,1)}

\item{textSize}{text size of the distribution plot (in px). Default = 12.}
}
\value{
A distribution plot for the selected variable as a ggplot object
}
\description{
Create distribution plot for one of the additional variable or
the percentage of the species present in the supertaxa.
}
\examples{
data("mainLongRaw", package="PhyloProfile")
data <- createVariableDistributionData(
    mainLongRaw, c(0, 1), c(0.5, 1)
)
varName <- "Variable abc"
varType <- "var1"
percent <- c(0,1)
textSize <- 12
createVarDistPlot(
    data,
    varName,
    varType,
    percent,
    textSize
)
}
\seealso{
\code{\link{mainLongRaw}},
\code{\link{createVariableDistributionData}},
\code{\link{createVariableDistributionDataSubset}},
\code{\link{createPercentageDistributionData}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
