% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{selectTimes}
\alias{selectTimes}
\title{selectTimes}
\usage{
selectTimes(mat, timepoint, order, percent, w, assay)
}
\arguments{
\item{mat}{a matrix (or PhosphoExperiment object) with rows correspond to 
phosphosites and columns correspond to samples in replicates for different 
treatments.}

\item{timepoint}{a timepoint as factor with a length equal to the
number of columns of mat.}

\item{order}{a vector specifying the order of timepoints.}

\item{percent}{a percent (decimal) from 0 to 1, to filter phosphosites with
with missing value larger than percent per timepoint.}

\item{w}{a timepoint window for selection of phosphosites to remove.}

\item{assay}{an assay to be selected if \code{mat} is a PhosphoExperiment 
object.}
}
\value{
a filtered matrix. If param \code{mat} is a SummarizedExperiment 
object, a SummarizedExperiment object will be returned.
}
\description{
selectTimes
}
\examples{
data("phospho_liverInsTC_RUV_sample")
timepoint = gsub("(.*)(\\\\d+[ms])(.*)", "\\\\2",
                colnames(phospho.liver.Ins.TC.ratio.RUV))
timepoint[which(timepoint == "0m")] = "0s"
timepoint = factor(timepoint)
timepointOrder = c("0s", "5s", "1m", "2m", "3m", "4m", "6m")

# For demonstration purpose, we introduce missing value at 0s
table(timepoint)

phospho.liver.Ins.TC.sim = phospho.liver.Ins.TC.ratio.RUV
rmId = which(timepoint == "0s")

# We replace the values to NA for the first 26 (~60\%) of the '0s' samples
# for the first 100 phosphosite as NA
phospho.liver.Ins.TC.sim[seq(100),rmId[seq(26)]] = NA

phospho.liver.Ins.TC.sim = selectTimes(phospho.liver.Ins.TC.sim,
                                    timepoint, timepointOrder, 0.5,
                                    w = length(table(timepoint)))

# For PhosphoExperiment objects
# mat = PhosR::PhosphoExperiment(
#     assay = phospho.liver.Ins.TC.sim,
#     colData = S4Vectors::DataFrame(
#         timepoint = timepoint
#     )
# )
# phospho.liver.Ins.TC.sim = selectTimes(mat, mat$timepoint, timepointOrder, 
#       0.5, w = length(table(mat$timepoint)))

# Before filtering
dim(phospho.liver.Ins.TC.ratio.RUV)
# After filtering
dim(phospho.liver.Ins.TC.sim)

}
