% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{selectLocalisedSites}
\alias{selectLocalisedSites}
\title{Select phosphosites by localisation score}
\usage{
selectLocalisedSites(mat, loc=NULL, prob = 0.75)
}
\arguments{
\item{mat}{a matrix (or PhosphoExperiment object) with rows corresponding to 
phosphosites and columns corresponding to samples in replicates for different 
treatments.}

\item{loc}{a vector of localisation scores}

\item{prob}{a percent from 0 to 1, specifying the localisation probability 
of quantified values in across all samples for retaining a phosphosite for 
subsequent analysis.}
}
\value{
a filtered matrix
}
\description{
Select phosphosites with a localisation score higher than the 
pre-defined probability score (default score = 0.75)
}
\examples{

data('phospho.cells.Ins.pe')
ppe <- phospho.cells.Ins.pe
ppe_mat <- as.data.frame(SummarizedExperiment::assay(ppe))
# Before filtering
dim(ppe)
dim(ppe_mat)

# Generate arbitrary localisation probabilities for each phosphosite
set.seed(2020)
localisation_scores <- round(rnorm(nrow(ppe), 0.8, 0.05), 2)
table(localisation_scores >= 0.75)

# Filter
Localisation(ppe) <- localisation_scores
ppe_filtered <- selectLocalisedSites(ppe, prob=0.75)
ppe_mat_filtered <- selectLocalisedSites(ppe_mat, loc=localisation_scores, 
     prob=0.75)

# After filtering
dim(ppe_filtered)
dim(ppe_mat_filtered)

}
