% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Impute.R
\name{scImpute}
\alias{scImpute}
\title{Site- and condition-specific (sc) impute}
\usage{
scImpute(mat, percent, grps, assay)
}
\arguments{
\item{mat}{a matrix (or PhosphoExperiment object) with rows correspond to 
phosphosites and columns correspond to replicates within a condition.}

\item{percent}{a percent from 0 to 1, specifying the percentage of quantified
values in any treatment group.}

\item{grps}{a string specifying the grouping (replciates).}

\item{assay}{an assay to be selected if \code{mat} is a PhosphoExperiment 
object.}
}
\value{
An imputed matrix. If param \code{mat} is a PhosphoExperiment 
object, a PhosphoExperiment object will be returned.
}
\description{
Impute the missing values for a phosphosite across replicates within a single
condition (or treatment)
if there are n or more quantified values of that phosphosite in that
condition.
}
\examples{

data('phospho.cells.Ins.sample')
grps = gsub('_[0-9]{1}', '', colnames(phospho.cells.Ins))
phospho.cells.Ins.filtered <- selectGrps(phospho.cells.Ins, grps, 0.5, n=1)

set.seed(123)
phospho.cells.Ins.impute <-
    scImpute(phospho.cells.Ins.filtered,
    0.5,
    grps)[,colnames(phospho.cells.Ins.filtered)]
    
# for PhosphoExperiment Object
data('phospho.cells.Ins.pe')
grps = gsub('_[0-9]{1}', '', colnames(phospho.cells.Ins.pe))
phospho.cells.Ins.filtered <- selectGrps(phospho.cells.Ins.pe, grps, 
    0.5, n=1)

set.seed(123)
phospho.cells.Ins.impute <-
    scImpute(phospho.cells.Ins.filtered,
    0.5,
    grps)[,colnames(phospho.cells.Ins.filtered)]

}
