% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RUVs.R
\name{RUVphospho}
\alias{RUVphospho}
\alias{RUVproteome}
\title{RUV for phosphoproteomics data normalisation}
\usage{
RUVphospho(
  mat,
  M,
  ctl,
  k = NULL,
  m = 1.6,
  s = 0.6,
  keepImpute = FALSE,
  assay = NULL,
  ...
)
}
\arguments{
\item{mat}{a matrix (or PhosphoExperiment object) with rows correspond to 
phosphosites and columns correspond to samples.}

\item{M}{is the design matrix as defined in RUVIII.}

\item{ctl}{is the stable phosphosites (or negative controls as defined in
RUVIII).}

\item{k}{is the number of unwanted factors as defined in RUVIII.}

\item{m}{a numeric number for controlling mean downshifting.}

\item{s}{a numeric number for controlling standard deviation of downshifted
sampling values.}

\item{keepImpute}{a boolean to keep the missing value in the returned matrix.}

\item{assay}{an assay to be selected if \code{mat} is a PhosphoExperiment 
object.}

\item{...}{additional parameters that may be passed to RUVIII.}
}
\value{
A normalised matrix.
}
\description{
This is a wrapper implementation of RUVIII for phosphoproteomics
data normalisation. This function will call
tailImpute function to impute all the missing values (if there is any) in the
phosphoproteomics data for
applying RUVIII. It will then return the normalised values for quantified
phosphosites and remove imputed values.
}
\examples{

data('phospho_L6_ratio_pe')
data('SPSs')

grps = gsub('_.+', '', colnames(phospho.L6.ratio.pe))

L6.sites = paste(sapply(GeneSymbol(phospho.L6.ratio.pe), function(x)paste(x)),
                 ";",
                 sapply(Residue(phospho.L6.ratio.pe), function(x)paste(x)),
                 sapply(Site(phospho.L6.ratio.pe), function(x)paste(x)),
                 ";", sep = "")

# Construct a design matrix by condition
design = model.matrix(~ grps - 1)

# phosphoproteomics data normalisation using RUV
ctl = which(L6.sites \%in\% SPSs)
phospho.L6.ratio.RUV = RUVphospho(
    SummarizedExperiment::assay(phospho.L6.ratio.pe, "Quantification"), 
    M = design, k = 3, ctl = ctl)

}
