% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhosphoExperiment.R
\docType{methods}
\name{PPE-accessors}
\alias{PPE-accessors}
\alias{UniprotID}
\alias{UniprotID<-}
\alias{GeneSymbol}
\alias{GeneSymbol<-}
\alias{Site}
\alias{Site<-}
\alias{Residue}
\alias{Residue<-}
\alias{Sequence}
\alias{Sequence<-}
\alias{Localisation}
\alias{Localisation<-}
\alias{UniprotID,PhosphoExperiment-method}
\alias{GeneSymbol,PhosphoExperiment-method}
\alias{Site,PhosphoExperiment-method}
\alias{Residue,PhosphoExperiment-method}
\alias{Sequence,PhosphoExperiment-method}
\alias{Localisation,PhosphoExperiment-method}
\alias{UniprotID<-,PhosphoExperiment-method}
\alias{GeneSymbol<-,PhosphoExperiment-method}
\alias{Site<-,PhosphoExperiment-method}
\alias{Residue<-,PhosphoExperiment-method}
\alias{Sequence<-,PhosphoExperiment-method}
\alias{Localisation<-,PhosphoExperiment-method}
\title{PhosphoExperiment object accessors}
\usage{
UniprotID(x, ...)

UniprotID(x) <- value

GeneSymbol(x, ...)

GeneSymbol(x) <- value

Site(x, ...)

Site(x) <- value

Residue(x, ...)

Residue(x) <- value

Sequence(x, ...)

Sequence(x) <- value

Localisation(x, ...)

Localisation(x) <- value

\S4method{UniprotID}{PhosphoExperiment}(x, withDimnames = TRUE)

\S4method{GeneSymbol}{PhosphoExperiment}(x, withDimnames = TRUE)

\S4method{Site}{PhosphoExperiment}(x, withDimnames = TRUE)

\S4method{Residue}{PhosphoExperiment}(x, withDimnames = TRUE)

\S4method{Sequence}{PhosphoExperiment}(x, withDimnames = TRUE)

\S4method{Localisation}{PhosphoExperiment}(x, withDimnames = TRUE)

\S4method{UniprotID}{PhosphoExperiment}(x) <- value

\S4method{GeneSymbol}{PhosphoExperiment}(x) <- value

\S4method{Site}{PhosphoExperiment}(x) <- value

\S4method{Residue}{PhosphoExperiment}(x) <- value

\S4method{Sequence}{PhosphoExperiment}(x) <- value

\S4method{Localisation}{PhosphoExperiment}(x) <- value
}
\arguments{
\item{x}{A \code{PhosphoExperiment} object to be assigned to.}

\item{...}{Ignored for accessors.}

\item{value}{A vector of values to set to respective accessor. See section 
\code{Available methods} for more details.}

\item{withDimnames}{A \code{logical(1)}, indicating whether the names of the 
vector should be applied.}
}
\description{
These are methods for getting for setting accessors of 
\code{PhosphoExperiment} object.
This provides some convenience for users.
}
\section{Available methods}{

 In the following code snippets, \code{ppe} is a 
 \linkS4class{PhosphoExperiment} object.

\describe{
\item{\code{UniprotID(ppe)}, \code{UniprotID(ppe) <- value}:}{Get or set a Uniprot ID, where \code{value} is a character 
vector}
\item{\code{GeneSymbol(ppe)}, \code{GeneSymbol(ppe) <- value}:}{Get or set a gene symbol , where \code{value} is a character 
vector}
\item{\code{Site(ppe)}, \code{Site(ppe) <- value}:}{Get or set a phosphorylation site, where \code{value} is a 
numeric vector}
\item{\code{Residue(ppe)}, \code{Residue(ppe) <- value}:}{Get or set a residue of phosphorylation site, where \code{value} is a 
character}
\item{\code{Sequence(ppe)}, \code{Sequence(ppe) <- value}:}{Get or set a sequence, where \code{value} is a character vector}
\item{\code{Localisation(ppe)}, \code{Localisation(ppe) <- localisation}:}{Get or set a localisation score, where \code{localisation} is a numeric 
vector}
}
}

\examples{
example(PhosphoExperiment, echo = FALSE)

UniprotID(phosData) <- uniprot
head(UniprotID(phosData))

GeneSymbol(phosData) <- symbol
head(GeneSymbol(phosData))

Site(phosData) <- site
head(Site(phosData))

Residue(phosData) <- res
head(Residue(phosData))

Sequence(phosData) <- seq
head(Sequence(phosData))

Localisation(phosData) <- rnorm(nrow(phosData))
head(Localisation(phosData))

}
\author{
Taiyun Kim
}
