% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaries.R
\name{librarySize}
\alias{librarySize}
\title{Calculate total read counts for each sample.}
\usage{
librarySize(object, ..., withDimnames = TRUE)
}
\arguments{
\item{object}{\linkS4class{PhIPData} object}

\item{...}{arguments passed to \link{colSums}}

\item{withDimnames}{logical; if true, the vector names are the sample names;
otherwise the vector is unnamed.}
}
\value{
a (named) numeric vector. The length of the vector is equal to the
number of samples.
}
\description{
This function is a wrapper function for \link{colSums} on the \code{counts}
assay.
}
\examples{
example("PhIPData")
librarySize(phip_obj)

## Return an unnamed vector
librarySize(phip_obj, withDimnames = FALSE)
}
