% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_plot_resize.R
\name{plot_resize_ui}
\alias{plot_resize_ui}
\alias{plot_resize_server}
\alias{plot_resize_demo}
\title{Render a resizable plot in a Shiny app}
\usage{
plot_resize_ui(id)

plot_resize_server(id, plot_ui_fn, init_width = "80\%", init_height = "400px")

plot_resize_demo(interactive = FALSE)
}
\arguments{
\item{id}{A string to identify the module.}

\item{plot_ui_fn}{A function to generate the UI of the plot.}

\item{init_width}{A string to set the initial width of the plot.}

\item{init_height}{A string to set the initial height of the plot.}

\item{interactive}{A boolean to indicate if the plot is interactive.}
}
\value{
A reactive list containing the width and height of the plot.
}
\description{
This function render a Shiny module into a resizable one.
It uses the \code{shinyjqui} package to make the plot resizable.
}
\examples{
if (interactive()) {
   plot_resize_demo(interactive = FALSE)
}
}
\keyword{internal}
