% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalizationMethods.R
\name{loessFNorm}
\alias{loessFNorm}
\title{Fast Loess Normalization of limma}
\usage{
loessFNorm(se, ain = "log2", aout = "LoessF", on_raw = FALSE)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomic dataset}

\item{ain}{String which assay should be used as input}

\item{aout}{String which assay should be used to save normalized data}

\item{on_raw}{Boolean specifying whether normalization should be performed on raw or log2-scaled data}
}
\value{
SummarizedExperiment containing the LoessF normalized data as assay (on log2 scale)
}
\description{
Using mean intensities over all the samples as its reference A sample. Log2-scaled data should be used as input (on_raw = FALSE).
}
\examples{
data(tuberculosis_TMT_se)
tuberculosis_TMT_se <- loessFNorm(tuberculosis_TMT_se, ain = "log2",
                                    aout = "LoessCyc", on_raw = FALSE)

}
\seealso{
\code{\link[limma]{normalizeCyclicLoess}()}
}
