% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{st000284}
\alias{st000284}
\title{Colorectal Cancer Detection Using Targeted Serum Metabolic Profiling}
\format{
A \code{SummarizedExperiment} object: 224 samples, 113 metabolites, 4 covariables and 3 groups (CRC, Healthy and Polyp).
\describe{
\item{metabolites}{113 serum metabolites.}
\item{covariables}{Age at consent, Gender, Smoking Condition and Alcohol Consumption.}
}
}
\source{
\url{https://www.metabolomicsworkbench.org/data/DRCCMetadata.php?Mode=Study&StudyID=ST000284&StudyType=MS&ResultType=1\%20target=_blank}
}
\usage{
st000284
}
\description{
Colorectal cancer (CRC) is one of the most prevalent and deadly cancers in the world. Despite an expanding knowledge of its molecular
pathogenesis during the past two decades, robust biomarkers to enable screening, surveillance, and therapy monitoring of CRC are still lacking.
In this study, we present a targeted liquid chromatography-tandem mass spectrometry-based metabolic profiling approach for identifying biomarker
candidates that could enable highly sensitive and specific CRC detection using human serum samples. In this targeted approach, 158 metabolites
from 25 metabolic pathways of potential significance were monitored in 234 serum samples from three groups of patients (66 CRC patients,
76 polyp patients, and 92 healthy controls). Partial least squares-discriminant analysis (PLS-DA) models were established, which proved to
be powerful for distinguishing CRC patients from both healthy controls and polyp patients. Receiver operating characteristic curves generated
based on these PLS-DA models showed high sensitivities (0.96 and 0.89, respectively, for differentiating CRC patients from healthy controls
or polyp patients); good specificities (0.80 and 0.88), and excellent areas under the curve (0.93 and 0.95) were also obtained. Monte Carlo
cross validation (MCCV) was also applied, demonstrating the robust diagnostic power of this metabolic profiling approach.
}
\references{
Colorectal Cancer Detection Using Targeted Serum Metabolic Profiling, J. Proteome. Res., 2014, 13, 4120-4130.
}
\keyword{datasets}
