% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaRandForest.R
\name{PomaRandForest}
\alias{PomaRandForest}
\title{Classification Random Forest}
\usage{
PomaRandForest(
  data,
  ntest = NULL,
  ntree = 500,
  mtry = floor(sqrt(ncol(t(SummarizedExperiment::assay(data))))),
  nodesize = 1,
  nvar = 20
)
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{ntest}{Numeric. Indicates the percentage of observations that will be used as test set. Default is NULL (no test set).}

\item{ntree}{Numeric. Indicates the number of trees to grow.}

\item{mtry}{Numeric. Indicates the number of variables randomly sampled as candidates at each split. This value is set sqrt(p) (where p is number of variables in data) by default.}

\item{nodesize}{Numeric. Indicates the minimum size of terminal nodes. Default is 1.}

\item{nvar}{Numeric. Indicates the number of variables to show in the Gini Index plot.}
}
\value{
A \code{list} with results including plots and tables.
}
\description{
\code{PomaRandForest} performs classification random forest. This method can be used both for prediction and variable selection.
}
\examples{
data <- POMA::st000336 \%>\% # Example SummarizedExperiment object included in POMA
  PomaImpute() \%>\% 
  PomaNorm()

## Output is a list with objects `MeanDecreaseGini` (tibble), `MeanDecreaseGini_plot` (ggplot2 object), `oob_error` (tibble), `error_tree` (ggplot2 object), and `model` (randomForest object)
data \%>\% 
  PomaRandForest(ntree = 500,
                 mtry = floor(sqrt(ncol(t(SummarizedExperiment::assay(data))))),
                 nodesize = 1,
                 nvar = 20)
}
\references{
A. Liaw and M. Wiener (2002). Classification and Regression by randomForest. R News 2(3), 18--22.
}
\author{
Pol Castellano-Escuder
}
