% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaPLS.R
\name{PomaPLS}
\alias{PomaPLS}
\title{Partial Least Squares Methods}
\usage{
PomaPLS(
  data,
  method = "pls",
  y = NULL,
  ncomp = 5,
  labels = FALSE,
  ellipse = TRUE,
  cross_validation = FALSE,
  validation = "Mfold",
  folds = 5,
  nrepeat = 10,
  vip = 1,
  num_features = 10,
  theme_params = list()
)
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{method}{Character. PLS method. Options include "pls", "plsda", and "splsda".}

\item{y}{Character. Indicates the name of \code{colData} columns to be used as dependent variable. If it's set to NULL, the first variable in \code{colData} will be used as the dependent variable.}

\item{ncomp}{Numeric. Number of components in the model. Default is 5.}

\item{labels}{Logical. Indicates if sample names should be displayed.}

\item{ellipse}{Logical. Indicates whether a 95 percent confidence interval ellipse should be displayed. Default is TRUE.}

\item{cross_validation}{Logical. Indicates if cross-validation should be performed for PLS-DA ("plsda") and sPLS-DA ("splsda") methods. Default is FALSE.}

\item{validation}{Character. (Only for "plsda" and "splsda" methods). Indicates the cross-validation method. Options are "Mfold" and "loo" (Leave-One-Out).}

\item{folds}{Numeric. (Only for "plsda" and "splsda" methods). Number of folds for "Mfold" cross-validation method (default is 5). If the validation method is "loo", this value is set to 1.}

\item{nrepeat}{Numeric. (Only for "plsda" and "splsda" methods). Number of times the cross-validation process is repeated.}

\item{vip}{Numeric. (Only for "plsda" method). Indicates the variable importance in the projection (VIP) cutoff.}

\item{num_features}{Numeric. (Only for "splsda" method). Number of features to discriminate groups.}

\item{theme_params}{List. Indicates \code{theme_poma} parameters.}
}
\value{
A \code{list} with results including plots and tables.
}
\description{
\code{PomaPLS} performs Partial Least Squares (PLS) regression, Partial Least Squares Discriminant Analysis (PLS-DA) to classify samples, and Sparse Partial Least Squares Discriminant Analysis (sPLS-DA) to classify samples (supervised analysis) and select variables.
}
\examples{
data <- POMA::st000284 \%>\% # Example SummarizedExperiment object included in POMA
  PomaImpute() \%>\% 
  PomaNorm()

## Output is a list with objects `factors` (tibble), `factors_plot` (ggplot2 object), `loadings` (tibble), and `loadings_plot` (ggplot2 object)
# PLS
data \%>\% 
  PomaPLS(method = "pls",
          y = NULL,
          ncomp = 5,
          labels = FALSE,
          ellipse = FALSE)

## Output is a list with objects `factors` (tibble), `factors_plot` (ggplot2 object), `vip_values` (tibble), and `vip_plot` (ggplot2 object)
# PLS-DA
data \%>\%
  PomaPLS(method = "plsda",
          y = NULL,
          ncomp = 5,
          labels = FALSE,
          ellipse = TRUE,
          cross_validation = FALSE,
          vip = 1)

# Alternative outcome (dependent variable)
data \%>\%
  PomaPLS(method = "plsda",
          y = "gender",
          ncomp = 5,
          labels = FALSE,
          ellipse = TRUE,
          cross_validation = FALSE,
          vip = 1)

## Output is a list with objects `factors` (tibble), `factors_plot` (ggplot2 object), `vip_values` (tibble), `vip_plot` (ggplot2 object), `errors` (tibble), and `errors_plot` (ggplot2 object)
# PLS-DA with Cross-Validation
data \%>\% 
  PomaPLS(method = "plsda",
          y = NULL,
          ncomp = 5,
          labels = FALSE,
          ellipse = TRUE,
          cross_validation = TRUE,
          validation = "Mfold",
          folds = 5,
          nrepeat = 10,
          vip = 1)

## Output is a list with objects `factors` (tibble), `factors_plot` (ggplot2 object), `selected_features` (tibble), and `selected_features_plot` (ggplot2 object)
# sPLS-DA
data \%>\% 
  PomaPLS(method = "splsda",
          y = NULL,
          ncomp = 5,
          labels = FALSE,
          ellipse = TRUE,
          cross_validation = FALSE,
          num_features = 10)

## Output is a list with objects `factors` (tibble), `factors_plot` (ggplot2 object), `selected_features` (tibble), `selected_features_plot` (ggplot2 object), `errors` (tibble), `errors_plot` (ggplot2 object), `optimal_components` (numeric value), and `optimal_features` (vector with optimal features per component)
# sPLS-DA with Cross-Validation
data \%>\% 
  PomaPLS(method = "splsda",
          y = NULL,
          ncomp = 3,
          labels = FALSE,
          ellipse = TRUE,
          cross_validation = TRUE,
          validation = "Mfold",
          folds = 5,
          nrepeat = 10,
          num_features = 10)
}
\author{
Pol Castellano-Escuder
}
