% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaEnrichment.R
\name{PomaEnrichment}
\alias{PomaEnrichment}
\title{Enrichment Analysis}
\usage{
PomaEnrichment(
  genes,
  method = "ora",
  organism = "Homo sapiens",
  collection = "C5",
  universe = NULL,
  rank = NULL,
  pval_cutoff = 0.05,
  fdr_cutoff = 0.1,
  min_size = 2,
  max_size = if (method == "gsea") {
     length(genes) - 1
 } else {
     NULL
 },
  max_genes = 10
)
}
\arguments{
\item{genes}{Character vector. Set of query gene symbols.}

\item{method}{Character. Enrichment method. Options are: 'ora' (simple over-representation analysis based on hypergeometric test) and 'gsea' (gene set enrichment analysis on a ranked list of genes).}

\item{organism}{Character. Indicates the model organism name. Default is 'Homo sapiens'. Other options are: 'Anolis carolinensis', 'Bos taurus', 'Caenorhabditis elegans', 'Canis lupus familiaris', 'Danio rerio', 'Drosophila melanogaster', 'Equus caballus', 'Felis catus', 'Gallus gallus', 'Macaca mulatta', 'Monodelphis domestica', 'Mus musculus', 'Ornithorhynchus anatinus', 'Pan troglodytes', 'Rattus norvegicus', 'Saccharomyces cerevisiae', 'Schizosaccharomyces pombe 972h-', 'Sus scrofa', 'Xenopus tropicalis'. See \code{msigdbr::msigdbr_show_species()}.}

\item{collection}{Character. Indicates the gene set collection. Default is 'C5' (Gene Ontology gene sets). Other options are: 'C1' (positional gene sets), 'C2' (curated gene sets), 'C3' (regulatory target gene sets), 'C4' (computational gene sets), 'C6' (oncogenic signature gene sets), 'C7' (immunologic signature gene sets), 'C8' (cell type signature gene sets), 'H' (Hallmark gene sets). See \code{msigdbr::msigdbr_collections()}.}

\item{universe}{Character vector. A universe from which 'genes' were selected.}

\item{rank}{Numeric vector. Ranking factor to sort genes for GSEA (e.g., logFC, -log10(p-value), etc).}

\item{pval_cutoff}{Numeric. Raw p-value cutoff on enrichment tests to report.}

\item{fdr_cutoff}{Numeric. Adjusted p-value cutoff on enrichment tests to report.}

\item{min_size}{Numeric. Minimal size of a gene set to test. All pathways below the threshold are excluded.}

\item{max_size}{Numeric. Maximal size of a gene set to test. All pathways above the threshold are excluded.}

\item{max_genes}{Numeric. The number of genes to retain from the \code{overlap_genes} or \code{leading_edge} columns. If \code{max_genes} is greater than the number of genes available, all genes are retained.}
}
\value{
A \code{tibble} with the enriched gene sets.
}
\description{
\code{PomaEnrichment} performs enrichment analysis on a set of query gene symbols using specified methods and gene set collections. It allows for the analysis of over-representation (ORA) or gene set enrichment (GSEA) in various model organisms.
}
\examples{
# Example genes
genes <- c("BRCA1", "TP53", "EGFR", "MYC", "PTEN")

# Perform ORA on Gene Ontology (C5) gene sets for Homo sapiens
PomaEnrichment(
  genes = genes,
  method = "ora",
  organism = "Homo sapiens",
  collection = "C5",
  pval_cutoff = 0.05,
  fdr_cutoff = 0.1,
  min_size = 10,
  max_size = 500)

# Example genes with ranking factors (e.g., logFC values)
genes <- c("Actb", "Gapdh", "Cdkn1a", "Cd44", "Pten")
rank <- c(2.5, -1.8, 3.1, -2.2, 1.7)

# Perform GSEA on Hallmark (H) gene sets for Mus musculus
PomaEnrichment(
  genes = genes,
  method = "gsea",
  organism = "Mus musculus",
  collection = "H",
  rank = rank,
  pval_cutoff = 0.05,
  fdr_cutoff = 0.25,
  min_size = 15,
  max_size = 500)
}
\author{
Pol Castellano-Escuder
}
