% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runPsScan.R
\name{runPsScan}
\alias{runPsScan}
\title{Run PS-Scan with Caching and Improved Execution}
\usage{
runPsScan(in_file, out_file, out_format, os = NULL)
}
\arguments{
\item{in_file}{Path to the input file containing protein sequences.}

\item{out_file}{Path for the output file where results will be saved.}

\item{out_format}{The output format for ps_scan (e.g., 'gff', 'psa').}

\item{os}{The operating system ('WIN', 'LINUX', 'MAC'). If NULL, it is
detected automatically.}
}
\value{
Invisibly returns the exit status of the ps_scan command. The primary
  output is the result file created at `out_file`.
}
\description{
This function runs the PROSITE ps_scan tool. It handles the downloading and
caching of required executables and databases using BiocFileCache, detects
the operating system, and executes the scan in a robust manner.
}
\examples{
# This example is resource-intensive and requires an internet connection
# on first run to cache necessary files.
if (interactive()) {
  # Create a dummy input file for the example
  fasta_content <- c(">sp|P02025|HEMA_MESAU Hemoglobin subunit alpha",
                     "MVLSAADKGNVKAAWGKVGGHAAEYGAEALERMFLSFPTTKTYFPHFDLSHGSAQVKGHG",
                     "KKVADALTNAVAHVDDMPNALSALSDLHAHKLRVDPVNFKLLSHCLLVTLAAHLPAEFT",
                     "PAVHASLDKFLASVSTVLTSKYR")
  in_file <- tempfile(fileext = ".fasta")
  writeLines(fasta_content, in_file)

  out_file <- tempfile(fileext = ".gff")

  # The first run will download and cache ~100MB of data.
  # Subsequent runs will use the cached files.
  runPsScan(in_file = in_file, out_format = 'gff', out_file = out_file)

  # Clean up temporary files
  unlink(in_file)
  unlink(out_file)
}

}
