% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readProsite.R
\name{readProsite}
\alias{readProsite}
\title{Convert PROSITE format to a GFF-like Data Frame}
\usage{
readProsite(prosite_input)
}
\arguments{
\item{prosite_input}{Path to the PROSITE scan output file.}
}
\value{
A data frame with columns approximating GFF fields plus additional
  PROSITE-specific information.
}
\description{
This function parses a file from a PROSITE scan into a data frame,
extracting information about motif occurrences into a GFF-like structure.
}
\examples{
prosite_file <- system.file("extdata", "PROSITEoutput.txt", package = "PMScanR")

# Check that the example file exists before running
if (nzchar(prosite_file)) {
  gff_like_data <- readProsite(prosite_file)
  # You can view the output with:
  # head(gff_like_data)
}

}
