% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_detection.R
\name{density_plot}
\alias{density_plot}
\title{Density Plot}
\usage{
density_plot(
    df,
    title = NULL,
    batch.legend.title = "Batch",
    xlab = "Value",
    color.set = NULL,
    title.hjust = 0.5
)
}
\arguments{
\item{df}{A data frame used to draw the density plots.}

\item{title}{Character, the plot title.}

\item{batch.legend.title}{Character, the legend title of batches.}

\item{xlab}{Character, x-axis title.}

\item{color.set}{A vector of character, indicating the set of colors to use.
The colors are represented by hexadecimal color code.}

\item{title.hjust}{Numeric, horizontal justification of the plot title,
in the range of \eqn{0} to \eqn{1}.}
}
\value{
None.
}
\description{
This function draws an overlap of multiple density plots for each batch.
}
\examples{
# The first example
library(TreeSummarizedExperiment) # for functions assays(),rowData()
data('AD_data')
# centered log ratio transformed data
ad.clr <- assays(AD_data$EgData)$Clr_value
ad.batch <- rowData(AD_data$EgData)$Y.bat # batch information
names(ad.batch) <- rownames(AD_data$EgData)
ad.df <- data.frame(value = ad.clr[,1], batch = ad.batch)
density_plot(df = ad.df, title = 'OTU 12')

# The second example
colorlist <- rainbow(10)
density_plot(df = ad.df, title = 'OTU 12', color.set = colorlist)

}
\seealso{
\code{\link{Scatter_Density}}, \code{\link{box_plot}},
\code{\link{alignment_score}} and \code{\link{partVar_plot}} as the other
methods for batch effect detection and batch effect removal assessment.
}
\author{
Yiwen Wang, Kim-Anh Lê Cao
}
