% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocessing.R
\name{PreFL}
\alias{PreFL}
\title{Prefiltering for Microbiome Data}
\usage{
PreFL(data, keep.spl = 10, keep.var = 0.01)
}
\arguments{
\item{data}{The data to be prefiltered. The samples in rows and variables
in columns.}

\item{keep.spl}{The minimum counts of a sample to be kept.}

\item{keep.var}{The minimum proportion of counts of a variable to be kept.}
}
\value{
\code{PreFL} returns a list that contains the following components:
\item{data.filter}{The filtered data matrix.}
\item{sample.idx}{The indexs of samples kept.}
\item{var.idx}{The indexs of variables kept.}
\item{zero.prob}{The proportion of zeros of the input data.}
}
\description{
This function prefilters the data to remove samples or microbial variables
with excess zeroes.
}
\examples{
library(TreeSummarizedExperiment) # for functions assays()
data('AD_data')

ad.count <- assays(AD_data$FullData)$Count # microbial count data
ad.filter.res <- PreFL(data = ad.count)

# The proportion of zeroes of the AD count data
ad.zero.prob <- ad.filter.res$zero.prob

# The filtered AD count data
ad.filter <- ad.filter.res$data.filter


}
\references{
\insertRef{le2016mixmc}{PLSDAbatch}
}
\author{
Yiwen Wang, Kim-Anh Lê Cao
}
