% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-trainModel.R
\name{trainModel,ClinicalModel-method}
\alias{trainModel,ClinicalModel-method}
\title{Fit a GLM Using Clinical Predictors Specified in a \code{ClinicalModel} Object.}
\usage{
\S4method{trainModel}{ClinicalModel}(
  object,
  ...,
  family = binomial(link = "logit"),
  na.action = na.exclude
)
}
\arguments{
\item{object}{A \code{ClinicalModel} object, with survival data for the model
in the colData slot.}

\item{...}{Fall through parameters to the \code{\link[stats:glm]{stats::glm}} function.}

\item{family}{Argument to the family parameter of \code{\link[stats:glm]{stats::glm}}. Defaults
to \code{binomial(link='logit')}. This parameter must be named.}

\item{na.action}{Argument to the na.action paramater of \code{\link[stats:glm]{stats::glm}}.
Deafults to 'na.omit', dropping rows with NA values in one or more of the
formula variables.}
}
\value{
A \code{ClinicalModel} object with a \code{glm} object in the models slot.
}
\description{
Fit a GLM Using Clinical Predictors Specified in a \code{ClinicalModel} Object.
}
\examples{
data(sampleClinicalModel)
set.seed(getModelSeed(sampleClinicalModel))

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

trainedClinicalModel <- trainModel(sampleClinicalModel)

}
