% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-CoxModel.R
\name{CoxModel}
\alias{CoxModel}
\title{CoxModel constructor}
\usage{
CoxModel(object, survivalPredictor = "metacluster_labels")
}
\arguments{
\item{object}{A \code{MultiAssayExperiment} containing only \code{SurvivalExperiment}
objects.}

\item{survivalPredictor}{A \code{character} vector indicating the name of the
one or more columns in the colData slot of each \code{SurvivalExperiment}
to use for testing survival differences between different groups. Must
be a valid column in the colData of ALL experiments.}
}
\value{
A \code{CoxModel} object, with \code{object} in the trainData slot.
}
\description{
Build a \code{CoxModel} object from a \code{MultiAssayExperiment} of
\code{SurvivalExperiment}s. Allows easy application of the
\code{survival::coxph} function to many \code{SurvivalExperiment} at once,
assuming they share the \code{survivalPredictor} column.
}
\examples{
library(MultiAssayExperiment)
data(CSPC_MAE)
experiments(CSPC_MAE) <- endoapply(experiments(CSPC_MAE), SurvivalExperiment,
    event_occurred='vital_status', survival_time='days_to_death')
coxModel <- CoxModel(CSPC_MAE, survivalPredictor='sample_type')

}
