% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/scanK.R
\name{scanK}
\alias{scanK}
\title{Run k-medoid algorithm with varying k on similarity matrix}
\usage{
scanK(SimiMatIn, quan=.95,cut=NULL, maxK=NULL,minSize=0, maxSize=200, fixK=NULL, rawscale=FALSE)
}
\arguments{
\item{SimiMatIn}{gene-by-gene similarity matrix}

\item{quan}{only gene pairs with similarity score >= quan th quantile will be
considered in the cluster analyses. Default is 0.95.}

\item{cut}{pre-defined cutoff. Gene pairs with similarity score >= cut will be considered in
cluster analyses. If cut is defined, quan will be ignored.}

\item{maxK}{max number of clusters to consider (scan). if numbC=NULL, it will be calculated as
[number of gene considered]/10.}

\item{minSize,maxSize}{Only clusters with minSize<= cluster size <= maxSize are
reported in output.}

\item{fixK}{if fixK is specified, the k-medoids algorithm will be applied with fixK clusters.}

\item{rawscale}{Recall the input
is the similarity matrix (-log10(distance from the sine model)).
the k-medoids clustering will be applied using (-Input) as distance. If rawscale is defined as TRUE,
the k-medoids clustering will be applied using -10^Input as distance.}
}
\value{
scanK() function runs k-medoid clustering with varying number of clusters (k).
The k is varied from 2 to maxK. The input of scanK() function should be a similarity matrix.
scanK() function will cluster genes in gene pairs with high similarity score (the threshold can be
defined using parameter quan). To select the top genes, the function first calculate the max similarity
score for each gene, then select the genes with high max score.

The output object is a list with 4 sublists:
membOut: members in each cluster. clusters are sorted by median similarity score within cluster;

MedCor: median similarity score for each cluster;

Mat: input similarity matrix;

filteredMat: similarity matrix, only showing the top genes used in clustering;

Kcluster: cluster indicator of each top gene.
}
\description{
Run k-medoid algorithm with varying k on similarity matrix
}
\examples{
aa <- sin(seq(0,1,.1))
bb <- sin(seq(0.5,1.5,.1))
cc <- sin(seq(0.9,1.9,.1))
tmp <- matrix(sin(rnorm(330)),ncol=11)
rownames(tmp) <- paste0("tmp",1:30)
Dat <- rbind(aa, bb, cc, tmp)
res1 <- OscopeSine(Dat)
res2 <- scanK(res1$SimiMat, quan=.8, maxK=5)
}
\author{
Ning Leng
}

