% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PermuCut.R
\name{PermuCut}
\alias{PermuCut}
\title{Define sine scroe cutoff using permuted data}
\usage{
PermuCut(Data, NumPermu=1000)
}
\arguments{
\item{Data}{a gene-by-sample (isoform-by-sample) matrix indicating the rescaled expression of genes/isoforms.
all values should be between [-1, 1].}

\item{NumPermu}{number of permuted genes to generate.}
}
\value{
Output contains a vector of numbers. Each number presents max sine score of a given
permuted gene.
}
\description{
Define sine scroe cutoff using permuted data
}
\examples{
aa <- sin(seq(0,1,.1))
bb <- sin(seq(0.5,1.5,.1))
cc <- sin(seq(0.9,1.9,.1))
tmp <- matrix(sin(rnorm(330)),ncol=11)
rownames(tmp) <- paste0("tmp",1:30)
Dat <- rbind(aa, bb, cc, tmp)
res1 <- PermuCut(Dat,100)
}
\author{
Ning Leng
}

