% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NISFun.R
\name{NISFun}
\alias{NISFun}
\title{Run Extended Nearest Insertion and 2-opt on a gene cluster identified by OscopeKM function}
\usage{
NISFun(ClusterList, DataIn, i, Ndg=3, NChun=4, RdmStart=FALSE, N=20000, NCThre=1000)
}
\arguments{
\item{ClusterList}{a list of gene clusters. Each sublist contains a vector of gene names.}

\item{DataIn}{gene-by-sample matrix or isoform-by-sample matrix.It should be rescaled to values bwteen
[-1,1].}

\item{i}{the cluster of interest. If the second cluster in ClusterList is of interest, specify i=2.}

\item{Ndg}{degree of polynomial.}

\item{NChun}{number of starting points for polynomial fitting.}

\item{RdmStart}{whether the start points are randomly selected.}

\item{N,NCThre}{The 2-opt algorithm will stop if N iterations has been performed or if the optimal order
remains unchanged for over NCThre iterations.}
}
\value{
This function performs the extended nearest insertion (ENI) and 2-opt algorithm to
a particular cluster identified by OscopeKM function.
The ENI algorithm searchs for the optimal sample order which minimizes the MSE of
sliding polynomial regression (SPR).
This function will call PipeShiftCDF() function, which fits
SPR to each row of the data.
For each gene/isoform, SPR fits NChun polynomial curves with different starting
points (samples). The samples with smaller order than the start point will be appended
to follow the last sample when fitting. So each fitting consider same number
 of samples. If RdmStart = TRUE, the start points are randomly selected.
Otherwise they are evenly sampled along the sample order.
The aggregated MSE of a fit (using a specific start point) is defined as the
summation of the MSEs of all genes/isoforms considered here.
The MSE of the SPR is defined as the largest aggregated MSE across fits
using different start points.
The output of PipeShiftCDF() returns the optimal order which provides the smallest SPR MSE.
The 2-opt algorithm is then applied to improve the optimal order searching of the ENI.
In each iteration, 2-opt algorithm will randomly choose two points (samples), the flip the samples
between these two points. The new order will be adapted if it provides smaller SPR MSE.
The output returns the optimal order for the cluster of interest.
}
\description{
Run Extended Nearest Insertion and 2-opt on a gene cluster identified by OscopeKM function
}
\examples{
aa <- sin(seq(0,1,.1))
bb <- sin(seq(0.5,1.5,.1))
cc <- sin(seq(0.9,1.9,.1))
res <- NISFun(list(c("aa","bb"),"cc"), rbind(aa,bb,cc),i=1, NChun=2, N=50)
}
\author{
Ning Leng
}

