% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intercell.R
\name{unique_intercell_network}
\alias{unique_intercell_network}
\title{Unique intercellular interactions}
\usage{
unique_intercell_network(network, ...)
}
\arguments{
\item{network}{An intercellular network data frame as produced by
\code{\link{intercell_network}}.}

\item{...}{Additional columns to keep. Note: if these have multiple
values for an interacting pair, only the first row will be
preserved.}
}
\value{
A data frame with interacting pairs and interaction attributes.
}
\description{
In the intercellular network data frames produced by \code{
\link{intercell_network}}, by default each pair of annotations for
an interaction is represented in a separate row. This function drops the
annotations and keeps only the distinct interacting pairs.
}
\examples{
icn <- intercell_network()
icn_unique <- unique_intercell_network(icn)

}
\seealso{
\itemize{
    \item{\code{\link{intercell_network}}}
    \item{\code{\link{simplify_intercell_network}}}
    \item{\code{\link{filter_intercell_network}}}
    \item{\code{\link{intercell}}}
    \item{\code{\link{intercell_categories}}}
    \item{\code{\link{intercell_generic_categories}}}
    \item{\code{\link{intercell_summary}}}
}
}
