% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netvis.R
\name{show_network}
\alias{show_network}
\title{Visualize node neighborhood with SigmaJS}
\usage{
show_network(interactions, node = NULL)
}
\arguments{
\item{interactions}{An OmniPath interaction data frame.}

\item{node}{The node of interest.}
}
\value{
A sigmaJS object, check http://sigmajs.john-coene.com/index.html
    for further details and customization options.
}
\description{
This function takes an OmniPath interaction data frame as input and
returns a sigmaJS object for the subgraph formed by the neighbors of a node
of interest.
}
\examples{
\dontrun{
# get interactions from omnipath
interactions <- omnipath()
# create and plot the network containing ATM neighbors
viz_sigmajs_neighborhood(interactions_df = interactions, int_node = "ATM")
}

}
