% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nichenet.R
\name{nichenet_ligand_target_matrix}
\alias{nichenet_ligand_target_matrix}
\title{Creates a NicheNet ligand-target matrix}
\usage{
nichenet_ligand_target_matrix(
  weighted_networks,
  lr_network,
  optimized_parameters,
  use_weights = TRUE,
  construct_ligand_target_matrix_param = list()
)
}
\arguments{
\item{weighted_networks}{Weighted networks as provided by
\code{\link{nichenet_build_model}}.}

\item{lr_network}{A data frame with ligand-receptor interactions, as
produced by \code{\link{nichenet_lr_network}}.}

\item{optimized_parameters}{The outcome of NicheNet parameter optimization
as produced by \code{\link{nichenet_build_model}}.}

\item{use_weights}{Logical: wether the network sources are weighted. In this
function it only affects the output file name.}

\item{construct_ligand_target_matrix_param}{Override parameters for
\code{nichenetr::construct_ligand_target_matrix}.}
}
\value{
A matrix containing ligand-target probability scores.
}
\description{
Creates a NicheNet ligand-target matrix
}
\examples{
\dontrun{
networks <- nichenet_networks()
expression <- nichenet_expression_data()
optimization_results <- nichenet_optimization(networks, expression)
nichenet_model <- nichenet_build_model(optimization_results, networks)
lt_matrix <- nichenet_ligand_target_matrix(
    nichenet_model$weighted_networks,
    networks$lr_network,
    nichenet_model$optimized_parameters
)
}

}
