% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/homologene.R
\name{homologene_uniprot_orthology}
\alias{homologene_uniprot_orthology}
\title{Orthology table with UniProt IDs}
\usage{
homologene_uniprot_orthology(target = 10090L, source = 9606L, by = entrez, ...)
}
\arguments{
\item{target}{Character or integer: name or ID of the target organism.}

\item{source}{Character or integer: name or ID of the source organism.}

\item{by}{Symbol or character: the identifier type in NCBI HomoloGene
to use. Possible values are "refseqp", "entrez", "genesymbol", "gi".}

\item{...}{Further arguments passed to \code{\link{translate_ids}}.}
}
\value{
A data frame with orthologous pairs of UniProt IDs.
}
\description{
Orthologous pairs of UniProt IDs for a pair of organisms, based on NCBI
HomoloGene data.
}
\examples{
homologene_uniprot_orthology(by = genesymbol)
# # A tibble: 14,235 × 2
#    source target
#    <chr>  <chr>
#  1 P11310 P45952
#  2 P49748 P50544
#  3 P24752 Q8QZT1
#  4 Q04771 P37172
#  5 Q16586 P82350
# # . with 14,230 more rows

}
