% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omixerSheet.R
\name{omixerSheet}
\alias{omixerSheet}
\title{Sample Sheet Generation}
\usage{
omixerSheet(omixerLayout = omixerLayout, group)
}
\arguments{
\item{omixerLayout}{Randomized sample list}

\item{group}{Colour-coding indicator}
}
\value{
PDF of sample layout in working directory
}
\description{
This function will generate visually intuitive plate layouts
for the wet lab, with the option to colour code different types
of samples (e.g. for studies investigating multiple tissues).
}
\examples{
library(tibble)
library(forcats)
library(stringr)

sampleList <- tibble(sampleId=str_pad(1:48, 4, pad="0"),
sex=as_factor(sample(c("m", "f"), 48, replace=TRUE)), 
age=round(rnorm(48, mean=30, sd=8), 0), 
smoke=as_factor(sample(c("yes", "ex", "never"), 48, replace=TRUE)),
date=sample(seq(as.Date('2008/01/01'), as.Date('2016/01/01'), 
               by="day"), 48))
               
randVars <- c("sex", "age", "smoke", "date")

omixerLayout <- omixerRand(sampleList, sampleId="sampleId", 
block="block", iterNum=10, wells=48, div="row", 
plateNum=1, randVars=randVars)

omixerSheet(omixerLayout)
}
