% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_collapse.R
\name{collapseDuplicatedReads,GAlignments-method}
\alias{collapseDuplicatedReads,GAlignments-method}
\title{Collapse duplicated reads}
\usage{
\S4method{collapseDuplicatedReads}{GAlignments}(x, addScoreColumn = TRUE, reuse.score.column = TRUE)
}
\arguments{
\item{x}{a GRanges, GAlignments or GAlignmentPairs object}

\item{addScoreColumn}{logical, default: (TRUE), if FALSE,
only collapse and not keep score column of counts for collapsed reads.
Returns directly without collapsing if reuse.score.column is FALSE and
score is already defined.}

\item{reuse.score.column}{logical (TRUE), if addScoreColumn is TRUE,
and a score column exists, will sum up the scores to create a new score.
If FALSE, will skip old score column and create new according to number
of replicated reads after conversion.
If addScoreColumn is FALSE, this argument is ignored.}
}
\value{
a GRanges, GAlignments, GAlignmentPairs or data.table object,
 same as input
}
\description{
For every GRanges, GAlignments read, with the same:
seqname, start, (cigar) / width and strand, collapse and give a new
meta column called "score", which contains the number of duplicates
of that read. If score column already exists, will return input object!
}
\examples{
gr <- rep(GRanges("chr1", 1:10,"+"), 2)
collapseDuplicatedReads(gr)
}
