% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_or_grl_helpers.R
\name{strandBool}
\alias{strandBool}
\title{Get logical list of strands}
\usage{
strandBool(grl)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} or GRanges object}
}
\value{
a logical vector
}
\description{
Helper function to get a logical list of True/False,
 if GRangesList group have + strand = T, if - strand = F
Also checks for * strands, so a good check for bugs
}
\examples{
gr <- GRanges(Rle(c("chr2", "chr2", "chr1", "chr3"), c(1, 3, 2, 4)),
              IRanges(1:10, width = 10:1),
              Rle(strand(c("-", "+", "*", "+", "-")), c(1, 2, 2, 3, 2)))
strandBool(gr)

}
