% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grl_extend.R
\name{extendTrailers}
\alias{extendTrailers}
\title{Extend the Trailers transcription stop sites}
\usage{
extendTrailers(
  grl,
  extension = 1000L,
  is.circular = all(isCircular(grl) \%in\% TRUE)
)
}
\arguments{
\item{grl}{usually a \code{\link{GRangesList}} of 3' utrs or transcripts.
Can be used for any extension of groups.}

\item{extension}{an integer, how much to max extend downstream (3' end).
Either single value that will apply for all, or same as length of grl
which will give 1 update value per grl object.
Or a GRangesList where start / stops sites by strand are the positions
to use as new starts.
Will not cross the chromosome boundary for non circular chromosomes.}

\item{is.circular}{logical, default FALSE if not any is: all(isCircular(grl) %in% TRUE).
Where grl is the ranges checked. If TRUE, allow ranges to extend
below position 1 on chromosome. Since circular genomes can have negative coordinates.}
}
\value{
an extended GRangeslist
}
\description{
Will extend the trailers or transcripts downstream (3' end) by extension.
The extension is general not relative, that means splicing
will not be taken into account.
Requires the \code{grl} to be sorted beforehand,
use \code{\link{sortPerGroup}} to get sorted grl.
}
\examples{
library(GenomicFeatures)
samplefile <- system.file("extdata", "hg19_knownGene_sample.sqlite",
                          package = "GenomicFeatures")
txdb <- loadDb(samplefile)
threeUTRs <- threeUTRsByTranscript(txdb) # <- extract only 5' leaders
tx <- exonsBy(txdb, by = "tx", use.names = TRUE)
## now try(extend downstream 1000):
extendTrailers(threeUTRs, extension = 1000)
## Or on transcripts
extendTrailers(tx, extension = 1000)
## Circular genome (allow negative coordinates)
circular_three <- threeUTRs
isCircular(circular_three) <- rep(TRUE, length(isCircular(circular_three)))
extendTrailers(circular_three, extension = 126200008L)[41] # <- negative stop coordinate

}
\seealso{
Other ExtendGenomicRanges: 
\code{\link{asTX}()},
\code{\link{coveragePerTiling}()},
\code{\link{extendLeaders}()},
\code{\link{reduceKeepAttr}()},
\code{\link{tile1}()},
\code{\link{txSeqsFromFa}()},
\code{\link{windowPerGroup}()}
}
\concept{ExtendGenomicRanges}
