% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_class.R
\name{design,experiment-method}
\alias{design,experiment-method}
\title{Get experimental design
Find the column/columns that create a separation between samples,
by default skips replicate and choose first that is
from either: libtype, condition, stage and fraction.}
\usage{
\S4method{design}{experiment}(
  object,
  batch.correction.design = FALSE,
  as.formula = FALSE,
  multi.factor = TRUE
)
}
\arguments{
\item{object}{an ORFik \code{\link{experiment}}}

\item{batch.correction.design}{logical, default FALSE. If true,
add replicate as a trailing design factor (only if >= 2 replicates exists).}

\item{as.formula}{logical, default FALSE. If TRUE, return as formula}

\item{multi.factor}{logical, default TRUE If FALSE, return first factor only
(+ rep, if batch.correction.design is true). Order of picking for single.factor
is: does libtype have > 1 level, if not then: stage, if not then: condition,
if not then: fraction.}
}
\value{
a character (name of column) or a formula
}
\description{
Get experimental design
Find the column/columns that create a separation between samples,
by default skips replicate and choose first that is
from either: libtype, condition, stage and fraction.
}
\examples{
df <- ORFik.template.experiment()
design(df) # The 2 columns that decides the design here
# If we subset it changes
design(df[df$libtype == "RFP",])
# Only single factor design, it picks first
design(df, multi.factor = FALSE)
}
