% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STAR_multiQC.R
\name{STAR.multiQC}
\alias{STAR.multiQC}
\title{Create STAR multiQC plot and table}
\usage{
STAR.multiQC(
  folder,
  type = "aligned",
  plot.ext = ".pdf",
  log_files = dir(folder, "Log.final.out", full.names = TRUE),
  simplified_table = TRUE
)
}
\arguments{
\item{folder}{path to LOGS folder of ORFik STAR runs. Can also be the path
to the aligned/ (parent directory of LOGS), then it will move into LOG
from there. Only if no files with pattern Log.final.out are found in
parent directory. If no LOGS folder is found it can check for a folder
/aligned/LOGS/ so to go 2 folders down.}

\item{type}{a character path, default "aligned".
Which subfolder to check for. If you want log files for contamination
do type = "contaminants_depletion"}

\item{plot.ext}{character, default ".pdf". Which format to save QC plot.
Alternative: ".png".}

\item{log_files}{character, path to "Log.final.out" STAR files,
default: dir(folder, "Log.final.out", full.names = TRUE)}

\item{simplified_table}{logical, default TRUE. Subset columns, to
the most important ones.}
}
\value{
a data.table with all information from STAR runs,
 plot and data saved to disc. Named:
"/00_STAR_LOG_plot.pdf" and "/00_STAR_LOG_table.csv"
}
\description{
Takes a folder with multiple Log.final.out files
from STAR, and create a multiQC report
}
\examples{
#' @examples
process_dir <- system.file("extdata/test_processing/", package = "ORFik")
STAR.multiQC(process_dir)

}
\seealso{
Other STAR: 
\code{\link{STAR.align.folder}()},
\code{\link{STAR.align.single}()},
\code{\link{STAR.allsteps.multiQC}()},
\code{\link{STAR.index}()},
\code{\link{STAR.install}()},
\code{\link{STAR.remove.crashed.genome}()},
\code{\link{getGenomeAndAnnotation}()},
\code{\link{install.fastp}()}
}
\concept{STAR}
